/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.command;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.CommandNoppesBase;
import noppes.npcs.client.EntityUtil;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.SyncController;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.entity.EntityDialogNpc;

public class CmdDialog
extends CommandNoppesBase {
    @Override
    public int func_82362_a() {
        return 2;
    }

    @Override
    public String getDescription() {
        return "Dialog operations";
    }

    @Override
    @Nonnull
    public String func_71517_b() {
        return "dialog";
    }

    @CommandNoppesBase.SubCommand(desc="force read", usage="<player> <dialog>", permission=2)
    public void read(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int dialogId;
        String playername = args[0];
        try {
            dialogId = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException ex) {
            throw new CommandException("DialogID must be an integer", new Object[0]);
        }
        List<PlayerData> data = PlayerDataController.instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            throw new CommandException("Unknown player '%s'", new Object[]{playername});
        }
        for (PlayerData playerdata : data) {
            playerdata.dialogData.read(dialogId);
            playerdata.save(true);
        }
    }

    @CommandNoppesBase.SubCommand(desc="reload dialogs from disk", permission=2)
    public void reload(MinecraftServer server, ICommandSender sender, String[] args) {
        new DialogController().load();
        SyncController.syncAllDialogs(server);
    }

    @CommandNoppesBase.SubCommand(desc="show dialog", usage="<player> <dialog> <name>", permission=2)
    public void show(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int dialogId;
        List players = CommandBase.func_193513_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
        try {
            dialogId = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException ex) {
            throw new CommandException("DialogID must be an integer: " + args[1], new Object[0]);
        }
        Dialog dialog = DialogController.instance.dialogs.get(dialogId);
        if (dialog == null) {
            throw new CommandException("Unknown dialog id: " + args[1], new Object[0]);
        }
        EntityDialogNpc npc = new EntityDialogNpc(sender.func_130014_f_());
        npc.dialogs = new int[]{dialogId};
        npc.display.setName(args[2]);
        for (EntityPlayer player : players) {
            EntityUtil.Copy((EntityLivingBase)player, (EntityLivingBase)npc);
            NoppesUtilServer.openDialog(player, npc, dialog);
        }
    }

    @CommandNoppesBase.SubCommand(desc="force unread dialog", usage="<player> <dialog>", permission=2)
    public void unread(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int dialogId;
        String playername = args[0];
        try {
            dialogId = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException ex) {
            throw new CommandException("DialogID must be an integer", new Object[0]);
        }
        List<PlayerData> data = PlayerDataController.instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            throw new CommandException("Unknown player '%s'", new Object[]{playername});
        }
        for (PlayerData playerdata : data) {
            playerdata.dialogData.dialogsRead.remove(dialogId);
            playerdata.save(true);
        }
    }
}

